/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef mx_mcp_interface_h
#define mx_mcp_interface_h

typedef int (mcp_select_mcp_t)(int, int, unsigned char **, int *, unsigned int *, 
			       unsigned int *);
typedef int (mcp_set_globals_t)(int, volatile uint8_t*);
typedef int (mcp_set_param_t)(int, volatile uint8_t *, const char *, uint32_t val);
typedef int (mcp_get_param_t)(int, volatile uint8_t *, const char *, uint32_t *val);
typedef int (mcp_get_counters_t)(int, const char***, uint32_t*);
typedef void *(mcp_get_log_events_t)(int);
typedef int (mcp_get_log_events_count_t)(int);
typedef int (mcp_init_mcp_t)(int, int);

#define MX_MCP_INTERFACE_VERSION 0

typedef struct mcp_interface
{
  int version;
  size_t memory_size;
#ifdef MX_MCP_INTERFACE_INTERNALS
  mx_mcp_public_global_t *globals;
#else
  void *globals;
#endif
  mcp_init_mcp_t *init;
  mcp_select_mcp_t *select_mcp;
  mcp_set_globals_t *set_globals;
  mcp_set_param_t *set_param;
  mcp_get_param_t *get_param;
  mcp_get_counters_t *get_counters;
  mcp_get_log_events_t *get_log_events;
  mcp_get_log_events_count_t *get_log_events_count;
} mcp_interface_t;

extern mcp_interface_t mx_mcpi;

#endif /* mx_mcp_interface_h */
